/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.crafting.feature;

import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import svenhjol.charm.crafting.ai.AIFormEndermite;
import svenhjol.charm.crafting.block.BlockEnderPearl;
import svenhjol.meson.Feature;
import svenhjol.meson.handler.RecipeHandler;
import svenhjol.meson.helper.WorldHelper;
import svenhjol.meson.registry.ProxyRegistry;

public class EnderPearlBlock
extends Feature {
    public static BlockEnderPearl block;
    public static float hardness;
    public static int range;
    public static boolean showParticles;
    public static boolean teleportStabilize;
    public static double endermiteChance;

    @Override
    public String getDescription() {
        return "A storage block for ender pearls. Eating a chorus fruit will teleport you to a nearby ender pearl block.\nIf a silverfish burrows into an ender pearl block, it will become an endermite.";
    }

    @Override
    public void configure() {
        super.configure();
        endermiteChance = this.propDouble("Silverfish burrowing", "Chance (out of 1.0) of a silverfish burrowing into an Ender Pearl Block, creating an Endermite.", 0.8);
        teleportStabilize = this.propBoolean("Teleport stabilization", "If true, eating a Chorus Fruit while in range of an Ender Pearl Block will teleport you to it.", true);
        hardness = 2.0f;
        range = 8;
        showParticles = true;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        block = new BlockEnderPearl();
        RecipeHandler.addShapedRecipe(ProxyRegistry.newStack(block, 1), "EEE", "EEE", "EEE", Character.valueOf('E'), Items.field_151079_bi);
        RecipeHandler.addShapelessRecipe(ProxyRegistry.newStack(Items.field_151079_bi, 9), ProxyRegistry.newStack(block));
    }

    public static boolean onChorusFruitEaten(World world, EntityLivingBase entity) {
        boolean didTeleport = false;
        if (!world.field_72995_K && entity != null && teleportStabilize) {
            double z;
            double y;
            double x;
            double distance = 0.0;
            BlockPos selectedPos = null;
            BlockPos entityPos = entity.func_180425_c();
            Iterable positions = BlockPos.func_177980_a((BlockPos)entityPos.func_177982_a(-range, -range, -range), (BlockPos)entityPos.func_177982_a(range, range, range));
            for (BlockPos pos : positions) {
                if (world.func_180495_p(pos).func_177230_c() != block || pos.func_177981_b(1).equals((Object)entityPos) || world.func_180495_p(pos.func_177981_b(1)).func_185904_a() != Material.field_151579_a || world.func_180495_p(pos.func_177981_b(2)).func_185904_a() != Material.field_151579_a) continue;
                double d = WorldHelper.getDistanceSq(entityPos, pos.func_177981_b(1));
                if (distance != 0.0 && !(d < distance)) continue;
                distance = d;
                selectedPos = pos.func_177981_b(1);
            }
            if (selectedPos != null && entity.func_184595_k(x = (double)selectedPos.func_177958_n() + 0.5, y = (double)selectedPos.func_177956_o(), z = (double)selectedPos.func_177952_p() + 0.5)) {
                world.func_184148_a(null, x, y, z, SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
                entity.func_184185_a(SoundEvents.field_187544_ad, 1.0f, 1.0f);
                didTeleport = true;
            }
            if (didTeleport && entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_184811_cZ().func_185145_a(Items.field_185161_cS, 20);
            }
        }
        return didTeleport;
    }

    @SubscribeEvent
    public void onEnterChunk(EntityEvent.EnteringChunk event) {
        if (event.getEntity() instanceof EntitySilverfish) {
            EntitySilverfish silverfish = (EntitySilverfish)event.getEntity();
            for (EntityAITasks.EntityAITaskEntry task : silverfish.field_70714_bg.field_75782_a) {
                if (!(task.field_75733_a instanceof AIFormEndermite)) continue;
                return;
            }
            silverfish.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIFormEndermite(silverfish));
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

